function database_panel(~,~)
%% should be used to get a list of compound available
%% should be used to make new compounds from those available

global database_frame launch_directory energy_start lambda_start  ...
    energy_end lambda_end step_energy rho  ...
    note stoec1 stoec2 stoec3 stoec4...
    element1 element2 element3 element4 file_name position calcul...
    E0 F0 iF0 E1 F1 iF1 E2 F2 iF2 ...
    x F_int...
    new_F_1 new_F_2 new_F_3 new_F_4 new_F ...
    Re_indop Im_indop n

database_directory='../Tables/cf/';
note_directory='../Tables/note/';

database_frame = figure(...
    'Units','normalized',...
    'Position',[0.15,0.15,.7,.7],...
    'Name','Database Panel and Scattering Factor Maker',...
    'Toolbar','none',...
    'MenuBar','none',...
    'Visible','on',...
    'Color',[0.5 0.5 1]);


    function start
        calcul=0;
        set(box_density, 'string', '');
        set(box_energy_start,'string',500);
        energy_start=str2double('50');
        set(box_energy_end,'string',1000);
        energy_end=str2double('1000');
        set(box_step_energy,'string',.1);
        step_energy=str2double('10');
        set(box_element1, 'string','');
        element1='';
        set(box_element2, 'string','');
        element2='';
        set(box_element3, 'string','');
        element3='';
        set(box_element4, 'string','');
        element4='';
        set(box_stoec1, 'string',0);
        stoec1=0;
        set(box_stoec2, 'string',0);
        stoec2=0;
        set(box_stoec3, 'string',0);
        stoec3=0;
        set(box_stoec4, 'string',0);
        stoec4=0;
        set(box_note, 'string','');
        note = '';
        n=floor((energy_end-energy_start)/step_energy)+1;
        
        Re_indop=zeros(n,1);
        Im_indop=zeros(n,1);
        
        F_int=zeros(n,7);
        new_F_1 = zeros(n,7);
        new_F_2 = zeros(n,7);
        new_F_3 = zeros(n,7);
        new_F_4 = zeros(n,7);
        new_F   = zeros(n,7);
        
    end

    function set_energy_variables(~,~)
        if calcul==0
            energy_start = str2double(get(box_energy_start,'String'));
            lambda_start = 12398.42/energy_start;
            energy_end = str2double(get(box_energy_end,'String' ));
            lambda_end = 12398.42/energy_end;
            step_energy =str2double(get(box_step_energy,'String'));
            graph;
            n=floor((energy_end-energy_start)/step_energy)+1;
            Re_indop=zeros(n,1);
            Im_indop=zeros(n,1);
            
        new_F_1 = zeros(n,7);
        new_F_2 = zeros(n,7);
        new_F_3 = zeros(n,7);
        new_F_4 = zeros(n,7);
        new_F   = zeros(n,7);
          
        elseif calcul==1
            energy_start = str2double(get(box_energy_start,'String'));
            lambda_start = 12398.42/energy_start;
            energy_end = str2double(get(box_energy_end,'String' ));
            lambda_end = 12398.42/energy_end;
            step_energy =str2double(get(box_step_energy,'String'));
            x=energy_start:step_energy:energy_end;
            n=floor((energy_end-energy_start)/step_energy)+1;
            Re_indop=zeros(n,1);
            Im_indop=zeros(n,1);
            
            new_F_1=[x',interp1(new_F_1(:,1),new_F_1(:,2:end), x(:))];
            
            new_F_2=[x',interp1(new_F_2(:,1),new_F_2(:,2:end), x(:))];
            
            new_F_3=[x',interp1(new_F_3(:,1),new_F_3(:,2:end), x(:))];
            
            new_F_4=[x',interp1(new_F_4(:,1),new_F_4(:,2:end), x(:))];
            
            new_F   = zeros(n,7);
            calc;
                     
        end
       
    end

    function set_insert_element(~,~)
        
        stoec1 = str2double(get(box_stoec1,'String'));
        stoec2 = str2double(get(box_stoec2,'String'));
        stoec3 = str2double(get(box_stoec3,'String'));
        stoec4 = str2double(get(box_stoec4,'String'));
    end

    function insert_note(~,~)
        note = get(box_note,'String');
        cd(note_directory);
        name=sprintf('%s.txt',file_name);
        dlmwrite(name, note, '');
        %fileread(name)
        cd(launch_directory);
    end

%% MAKE LIST OF COMPOUND
% read the tables, list the content of the directory and save the list into
% a string that can be loaded into the listbox
% if isempty(database_directory)
% [dummy,database_directory] = uigetfile('*.mat','dyna: indicate database directory by picking a filename in the directory');
% end



    function select_compound(~,~)
        calcul=0;
        set(btn_delete,'Enable','on');
        set(btn_insert,'Enable','on');
        compound_to_add=get(listbox_compounds,'Value');
        file_name = char(c(compound_to_add, : ));
        cf_file=load(sprintf('../Tables/cf/%s.cf',file_name));
        mf_file=load(sprintf('../Tables/mf/%s.mf',file_name));
        cf2_file=load(sprintf('../Tables/cf2/%s.cf2',file_name));
        E0 =  cf_file(:,1);
        F0 =  cf_file(:,2);
        iF0 = cf_file(:,3);
        E1  = mf_file(:,1);
        F1  = mf_file(:,2);
        iF1 = mf_file(:,3);
        E2  = cf2_file(:,1);
        F2  = cf2_file(:,2);
        iF2 = cf2_file(:,3);
        graph ;
        note=fileread(sprintf('../Tables/note/%s.txt',file_name));
        set(box_note, 'enable','on')
        set(box_note, 'string',note);
        
    end
    function interpolation
        x=energy_start:step_energy:energy_end;
        n=floor((energy_end-energy_start)/step_energy)+1;
        F_int=zeros(n,7);
        F_int(:,1)=x';
        F_int(:,2)=interp1(E0, F0, x(:));
        F_int(:,3)=interp1(E0, iF0, x(:));
        F_int(:,4)=interp1(E1, F1, x(:));
        F_int(:,5)=interp1(E1, iF1, x(:));
        F_int(:,6)=interp1(E2, F2, x(:));
        F_int(:,7)=interp1(E2, iF2, x(:));
    end
    function graph(~,~)
        interpolation;
        plot(x, F_int(:,2), '-r');
        hold on
        plot(x, F_int(:,3), '-b');
        plot(x, F_int(:,4), ':r');
        plot(x, F_int(:,5), ':b');
        plot(x, F_int(:,6), '--r');
        plot(x, F_int(:,7), '--b');
        set(graph_database_frame,'Color',[0.992 0.918 0.796]);
        hold off
       
    end

%%
%bouton
btn_insert=uicontrol('Parent',database_frame,...
    'Units','normalized', ...
    'enable','off',...
    'Position',[.23 .15 .12 .08], ...
    'String','Insert', ...
    'Callback',@insert_element,...
    'TooltipString','Insert Layer');

position=0;
   
    function insert_element(~,~)
        interpolation;
        position = position+1;
        if position == 1
            element1 = file_name;
            set(box_element1,'string',element1);
            E=energy_start:step_energy:energy_end;
            new_F_2(:,1)=E';
            new_F_3(:,1)=E';
            new_F_4(:,1)=E';
            new_F_1=F_int;
            
        elseif position==2
            element2 = file_name;
            set(box_element2,'string',element2);
            E=energy_start:step_energy:energy_end;
            new_F_3(:,1)=E';
            new_F_4(:,1)=E';
            new_F_2=F_int;
            
        elseif position==3
            element3 = file_name;
            set(box_element3,'string',element3);
            E=energy_start:step_energy:energy_end;
            new_F_4(:,1)=E';
            new_F_3=F_int;
            
        elseif position==4
            element4 = file_name;
            set(box_element4,'string',element4);
            new_F_4=F_int;
            
        end
        
    end

btn_delete=uicontrol('Parent',database_frame,...
    'Units','normalized', ...
    'enable','off',...
    'Position',[.23 .05 .12 .08], ...
    'String','delete', ...
    'Callback',@delete_element,...
    'TooltipString','Insert Layer');

    function delete_element(~,~)
        position = position-1;
        if position == 3
            element4 = '';
            set(box_element4,'string','');
            new_F_4=zeros(n,7);
            
            
        elseif position==2
            element3 = '';
            set(box_element3,'string','');
            new_F_3=zeros(n,7);
            
            
        elseif position==1
            element2 = '';
            set(box_element2,'string','');
            new_F_2=zeros(n,7);
            
        elseif position==0
            element1 = '';
            set(box_element1,'string','');
            new_F_1=zeros(n,7);
            
        end
        
    end

uicontrol('Parent',database_frame,...
    'Units','normalized', ...
    'Position',[.42 .94 .08 .05], ...
    'String','cf', ...
    'Callback',@cf_graph,...
    'TooltipString','Insert Layer');

    function cf_graph(~,~)
        interpolation;
        if calcul==0
            plot(x, F_int(:,2), '-r');
            hold on
            plot(x, F_int(:,3), '-b');
            set(graph_database_frame,'Color',[0.992 0.918 0.796]);
            hold off
        elseif calcul==1
            plot(x, new_F(:,2), '-r');
            hold on
            plot(x, new_F(:,3), '-b');
            set(graph_database_frame,'Color',[0.992 0.918 0.796]);
            hold off
        end
    end

uicontrol('Parent',database_frame,...
    'Units','normalized', ...
    'Position',[.5 .94 .08 .05], ...
    'String','mf', ...
    'Callback',@mf_graph,...
    'TooltipString','Insert Layer');

    function mf_graph(~,~)
        interpolation;
        if calcul==0
            plot(x, F_int(:,4), '-r');
            hold on
            plot(x, F_int(:,5), '-b');
            set(graph_database_frame,'Color',[0.992 0.918 0.796]);
            hold off
        elseif calcul==1
            plot(x, new_F(:,4), '-r');
            hold on
            plot(x, new_F(:,5), '-b');
            set(graph_database_frame,'Color',[0.992 0.918 0.796]);
            hold off
        end
    end


uicontrol('Parent',database_frame,...
    'Units','normalized', ...
    'Position',[.58 .94 .08 .05], ...
    'String','cf2', ...
    'Callback',@cf2_graph,...
    'TooltipString','Insert Layer');

    function cf2_graph(~,~)
        interpolation;
        if calcul==0
            plot(x, F_int(:,6), '-r');
            hold on
            plot(x, F_int(:,7), '-b');
            set(graph_database_frame,'Color',[0.992 0.918 0.796]);
            hold off
        elseif calcul==1
            plot(x, new_F(:,6), '-r');
            hold on
            plot(x, new_F(:,7), '-b');
            set(graph_database_frame,'Color',[0.992 0.918 0.796]);
            hold off
        end
    end

uicontrol('Parent',database_frame,...
    'Units','normalized', ...
    'Position',[.78 .94 .08 .05], ...
    'String','n', ...
    'Callback',@indop_graph,...
    'TooltipString','Insert Layer');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    function indop_graph(~,~)
        interpolation;
        %rho=1; %valeur ??? d???finir
        if calcul==0
            for i=1:n
                E=energy_start+i*step_energy;
                Re_indop(i,1)=1+2*pi/(E*E)*12398.42*12398.42*rho*F_int(i,1);
                Im_indop(i,1)=1+2*pi/(E*E)*12398.42*12398.42*rho*F_int(i,2);
            end
            
            plot(x, Re_indop, '-r');
            hold on
            plot(x, Im_indop, '-b');
            set(graph_database_frame,'Color',[0.992 0.918 0.796]);
            hold off
        elseif calcul==1
            for i=1:n
                E=energy_start+i*step_energy;
                Re_indop(i,1)=1+2*pi/(E*E)*12398.42*12398.42*rho*new_F(i,1);
                Im_indop(i,1)=1+2*pi/(E*E)*12398.42*12398.42*rho*new_F(i,2);
            end
            
            plot(x, Re_indop, '-r');
            hold on
            plot(x, Im_indop, '-b');
            set(graph_database_frame,'Color',[0.992 0.918 0.796]);
            hold off
        end
    end

    function density(~,~)
        rho=str2double(get(box_density,'String'));
        set(slider_density,'Value',rho);
    end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

uicontrol('Parent',database_frame,...
    'Units','normalized', ...
    'Position',[.66 .94 .08 .05], ...
    'String','all', ...
    'Callback',@all_curves_graph,...
    'TooltipString','Insert Layer');

    function all_curves_graph(~,~)
        interpolation;
        if calcul==0
           plot(x, F_int(:,2), '-r');
        hold on
        plot(x, F_int(:,3), '-b');
        plot(x, F_int(:,4), ':r');
        plot(x, F_int(:,5), ':b');
        plot(x, F_int(:,6), '--r');
        plot(x, F_int(:,7), '--b');
        set(graph_database_frame,'Color',[0.992 0.918 0.796]);
        hold off
       
        elseif calcul==1
           plot(x, new_F(:,2), '-r');
        hold on
        plot(x, new_F(:,3), '-b');
        plot(x, new_F(:,4), ':r');
        plot(x, new_F(:,5), ':b');
        plot(x, new_F(:,6), '--r');
        plot(x, new_F(:,7), '--b');
        set(graph_database_frame,'Color',[0.992 0.918 0.796]);
        hold off
       
        end
        
    end


uicontrol('Parent',database_frame,...
    'Units','normalized', ...
    'Position',[.6 .15 .09 .05], ...
    'String','Calcul', ...
    'Callback',@calc,...
    'TooltipString','Insert Layer');

    function calc(~,~)
        calcul=1;
        new_F=[x',stoec1*new_F_1(:,2:end)+stoec2*new_F_2(:,2:end)+stoec3*new_F_3(:,2:end)+stoec4*new_F_4(:,2:end)];
        plot(x, new_F(:,2), '-r');
        hold on
        plot(x, new_F(:,3), '-b');
        plot(x, new_F(:,4), ':r');
        plot(x, new_F(:,5), ':b');
        plot(x, new_F(:,6), '--r');
        plot(x, new_F(:,7), '--b');
        set(graph_database_frame,'Color',[0.992 0.918 0.796]);
        hold off
        
       if stoec1==0
           note_def=sprintf('');
       elseif stoec2==0
           note_def=sprintf('fichier %s%g% : cf, mf et cf2 proviennent des calculs de dyna',element1, stoec1);
       elseif stoec3==0
           note_def=sprintf('fichier %s%g%s%g : cf, mf et cf2 proviennent des calculs de dyna',element1, stoec1, element2, stoec2);
       elseif stoec4==0
           note_def=sprintf('fichier %s%g%s%g%s%g : cf, mf et cf2 proviennent des calculs de dyna',element1, stoec1, element2, stoec2, element3, stoec3);
       else
           note_def=sprintf('fichier %s%g%s%g%s%g%s%g : cf, mf et cf2 proviennent des calculs de dyna',element1, stoec1, element2, stoec2, element3, stoec3, element4, stoec4);
       end
        
        set(box_note,'string',note_def);
       
    end

btn_save=uicontrol('Parent',database_frame,...
    'Units','normalized', ...
    'Position',[.9 .15 .09 .05], ...
    'String','save', ...
    'Callback',@save_table,...
    'TooltipString','Insert Layer');

    function save_table(~,~)
              
        table_directory='../Tables/cf/';
        cd(table_directory);
        get_name=get(box_savefilename,'String');
        get_name
        results_cf=new_F(:,[1 2:3]);
        save(sprintf('%s.cf',get_name),'results_cf','-ASCII')
        cd(launch_directory);cd('../Tables/mf/')
        results_mf=new_F(:,[1 4:5]);
        save(sprintf('%s.mf',get_name),'results_mf','-ASCII')
        cd(launch_directory);cd('../Tables/cf2/')
        results_cf2=new_F(:,[1 6:7]);
        save(sprintf('%s.cf2',get_name),'results_cf2','-ASCII')
        cd(launch_directory);
        note = get(box_note,'String');
        cd(note_directory);
        dlmwrite(sprintf('%s.note',get_name), note, '');
        cd(launch_directory);
        
    end


%% GUI
set(0,'Units','normalized');
get(0,'ScreenSize');


graph_database_frame = axes('parent', database_frame,...
    'Units','normalized', ...
    'Box','on', ...
    'Color',[0.992 0.918 0.796], ...
    'FontSize',10,...
    'Position',[0.405 0.28 0.58 0.65], ...
    'XColor',[0 0 0], ...
    'YColor',[0 0 0]);

uicontrol('Parent',database_frame,...
    'Style','text',...
    'BackgroundColor',[.5 .5 1], ...
    'FontWeight','bold',...
    'String','Name' ,...
    'Units','normalized', ...
    'Position',[.065 .95 .075 .03]);

uicontrol('Parent',database_frame,...
    'Style','text',...
    'BackgroundColor',[.5 .5 1], ...
    'FontWeight','bold',...
    'String','Energy' ,...
    'Units','normalized', ...
    'Position',[.25 .8 .1 .02]);

listbox_compounds = uicontrol('Parent',database_frame,...
    'Units','normalized', ...
    'BackgroundColor',[1 1 1], ...
    'Position',[0.025 .05 .18 .9], ...
    'Style','listbox', ...
    'Min',0,...
    'Max',1,...
    'Callback',@select_compound,...
    'FontName','Monospaced',...
    'FontSize',12,...
    'Value',1);

box_note=uicontrol('Parent',database_frame,	'Units','normalized', ...
    'style','edit',...
    'Max', 20, ...
    'BackgroundColor',[1 1 1], ...
    'FontSize',10, ...
    'Position',[.6 .02 .38 .1], ...
    'String', note, ...
    'Enable','off',...
    'Callback',@insert_note);

defaultBackground = get(0,'defaultUicontrolBackgroundColor');

% energy panel
panel_energy=uipanel('parent',database_frame,'Units','normalized', ...
    'Position',[.22 .45 .15 .3],'BackgroundColor',defaultBackground);

uicontrol('Parent',panel_energy,'Units','normalized', ...
    'FontSize',10, 'Position',[.01 .75 .4 .12], ...
    'String','Start', 'Style','text');

uicontrol('Parent',panel_energy,	'Units','normalized', ...
    'FontSize',10, ...
    'Position',[.01 .45 .4 .12], 'String','End', 'Style','text');

uicontrol('Parent',panel_energy,	'Units','normalized', ...
    'FontSize',10, 'Position',[.01 .15 .4 .12], ...
    'String','Step', 'Style','text');

box_energy_start=uicontrol('Parent',panel_energy,'Units','normalized', ...
    'BackgroundColor',[1 1 1], ...
    'FontSize',10, ...
    'Position',[.3 .73 .5 .2], ...
    'String', energy_start, ...
    'Enable','on',...
    'Style','edit',...
    'Callback',@set_energy_variables);

box_energy_end=uicontrol('Parent',panel_energy,	'Units','normalized', ...
    'BackgroundColor',[1 1 1], 'FontSize',10, ...
    'Position',[.3 .43 .5 .2], 'String',energy_end, ...
    'Enable','on','Style','edit', ...
    'Callback',@set_energy_variables);

box_step_energy=uicontrol('Parent',panel_energy,'Units','normalized', ...
    'BackgroundColor',[1 1 1], 'FontSize',10, ...
    'Enable','on','Position',[.3 .13 .5 .2], ...
    'String', step_energy, ...
    'Style','edit', 'TooltipString','Step scan energy', ...
    'Callback',@set_energy_variables);

%new element panel
panel_new_element=uipanel('parent',database_frame,'Units','normalized', ...
    'Position',[.38 .02 .2 .23],'BackgroundColor',defaultBackground);

uicontrol('Parent',panel_new_element,...
    'Style','text','FontWeight','bold',...
    'String','New element','Units','normalized', ...
    'Position',[.1 .85 .8 .1]);


uicontrol('Parent',panel_new_element,'Units','normalized', ...
    'FontSize',10, 'Position',[.05 .75 .4 .1], ...
    'String','coeff. stoech.','Style','text');

uicontrol('Parent',panel_new_element,'Units','normalized', ...
    'FontSize',10,'Position',[.55 .75 .4 .1], ...
    'String','element','Style','text');

box_element1=uicontrol('Parent',panel_new_element,	'Units','normalized', ...
    'BackgroundColor',[1 1 1],'FontSize',10, ...
    'Position',[.52 .55 .45 .15],'String', element2, ...
    'Enable','off',...
    'Style','edit',...
    'Callback',@insert_element);

box_stoec1=uicontrol('Parent',panel_new_element,	'Units','normalized', ...
    'BackgroundColor',[1 1 1], 'FontSize',10, ...
    'Position',[.02 .55 .45 .15], ...
    'String', stoec1, 'Enable','on',...
    'Style','edit', 'Callback',@set_insert_element);

box_element2=uicontrol('Parent',panel_new_element,	'Units','normalized', ...
    'BackgroundColor',[1 1 1], ...
    'FontSize',10, ...
    'Position',[.52 .38 .45 .15], ...
    'String', element2, ...
    'Enable','off',...
    'Style','edit',...
    'Callback',@insert_element);

box_stoec2=uicontrol('Parent',panel_new_element,	'Units','normalized', ...
    'BackgroundColor',[1 1 1], ...
    'FontSize',10, ...
    'Position',[.02 .38 .45 .15], ...
    'String', stoec2, ...
    'Enable','on',...
    'Style','edit',...
    'Callback',@set_insert_element);

box_element3=uicontrol('Parent',panel_new_element,	'Units','normalized', ...
    'BackgroundColor',[1 1 1], ...
    'FontSize',10, ...
    'Position',[.52 .21 .45 .15], ...
    'String', element3, ...
    'Enable','off',...
    'Style','edit',...
    'Callback',@insert_element);

box_stoec3=uicontrol('Parent',panel_new_element,	'Units','normalized', ...
    'BackgroundColor',[1 1 1], ...
    'FontSize',10, ...
    'Position',[.02 .21 .45 .15], ...
    'String', stoec3, ...
    'Enable','on',...
    'Style','edit',...
    'Callback',@set_insert_element);

box_element4=uicontrol('Parent',panel_new_element,	'Units','normalized', ...
    'BackgroundColor',[1 1 1], ...
    'FontSize',10, ...
    'Position',[.52 .04 .45 .15], ...
    'String', element4, ...
    'Enable','off',...
    'Style','edit',...
    'Callback',@insert_element);

box_stoec4=uicontrol('Parent',panel_new_element,	'Units','normalized', ...
    'BackgroundColor',[1 1 1], ...
    'FontSize',10, ...
    'Position',[.02 .04 .45 .15], ...
    'String', stoec4, ...
    'Enable','on',...
    'Style','edit',...
    'Callback',@set_insert_element);

% indice optique, densit??? rho
uicontrol('Parent',database_frame,...
    'Style','text',...
    'FontWeight','bold',...
    'FontSize',10,...
    'String','Density [mol/cm^3]' ,...
    'Units','normalized', ...
    'Position',[0.86 0.97 .12 .02],...
    'TooltipString','(density/atomic weight) [mol/cm^3]');

box_density=uicontrol('Parent',database_frame,'Units','normalized', ...
    'BackgroundColor',[1 1 1], ...
    'FontSize',10, ...
    'Position',[0.87 .94 .09 .03], ...
    'String', rho, ...
    'Enable','on',...
    'Style','edit',...
    'Callback',@density);

box_savefilename= uicontrol('Parent',database_frame,'Units','normalized', ...
    'BackgroundColor',[1 1 1], ...
    'FontSize',10, ...
    'Position',[.75 .15 .09 .05], ...
    'String', 'filename', ...
    'Enable','on',...
    'Style','edit');



%% END GUI
start
%% LIST

cd(database_directory);
a=dir;
a=a(3:end);
b=size(a);
l=b(1);
c=cell(l,1);
for ii=1:b(1)
    d=a(ii).name;
    c(ii,1)=cellstr(d(1,1:end-3));
end
cd(launch_directory);

set(listbox_compounds,'String',c);
end