function [lcalc]=F0F1_ef(lcalc,lsim,layer,SF,sequence)
% vectorized version of Elzo's formalism
% vectorizing requires developping some matrix multiplications, resulting
% in this heavy code
% see unvectorized version for a lighter but slower code
% CNRS Institut Neel - M. Elzo & S. Grenier


wave_k =5.0677e-4*lsim.energy(1);%twopi/12398.42
kz=zeros(length(layer)+1,length(lcalc.reflectivity(1,:)));
eps=1;eps_mag=0;eps_xy=0;eps_yz=0;eps_xz=0;twoeps2=2;%initial for vaccum
u=[0;0;0];
Am = zeros(4,4,length(layer)+1,length(lcalc.reflectivity(1,:)));
Am_phi = zeros(4,4,length(layer)+1,length(lcalc.reflectivity(1,:)));
Am_m1 = zeros(4,4,length(layer)+1,length(lcalc.reflectivity(1,:)));
Am_m1_phi = zeros(4,4,length(layer)+1,length(lcalc.reflectivity(1,:)));
F = zeros(4,4,length(layer)+1,length(lcalc.reflectivity(1,:))); % could be 4,4,len(ref)
F_phi = zeros(4,4,length(layer)+1,length(lcalc.reflectivity(1,:)));
P = zeros(4,4,length(layer)+1,length(lcalc.reflectivity(1,:)));
P_phi = zeros(4,4,length(layer)+1,length(lcalc.reflectivity(1,:)));
S = zeros(4,4,length(layer)+1,length(lcalc.reflectivity(1,:)));
S_phi = zeros(4,4,length(layer)+1,length(lcalc.reflectivity(1,:)));
lcalc.M_final= zeros(2,2,length(lcalc.reflectivity(1,:)));
lcalc.M_final_phi= zeros(2,2,length(lcalc.reflectivity(1,:)));
M_final_temp=lcalc.M_final;
M_final_temp_phi=lcalc.M_final_phi;
thick=zeros(1,length(layer)+1);
rough=zeros(1,length(layer)+1);

alpha = lcalc.reflectivity(1,:); %one line
alphay_0 = cos(alpha); %one line

S(1,1,:,:)=1; S(2,2,:,:)=1; S(3,3,:,:)=1; S(4,4,:,:)=1;
S_phi(1,1,:,:)=1; S_phi(2,2,:,:)=1; S_phi(3,3,:,:)=1; S_phi(4,4,:,:)=1;

for k=1:length(layer)+1
    
  if k>1 
    cappa = 830.9471/lsim.energy(1)^2*layer(k-1).density(2);
    eps = 1 - cappa*SF.cf(k,1); twoeps2=2*eps^2;  
    eps_mag = cappa*layer(k-1).MMS(2)*SF.mf(k,1);
    u  = [sind(layer(k-1).phi(2))*cosd(layer(k-1).gamma(2));...
          sind(layer(k-1).phi(2))*sind(layer(k-1).gamma(2));...
          cosd(layer(k-1).phi(2))];
    eps_xy = - 1i *u(3)*eps_mag;
    eps_xz =   1i *u(2)*eps_mag;
    eps_yz = - 1i *u(1)*eps_mag;
    thick(k)=layer(k-1).thickness(2);
    rough(k)=layer(k-1).roughness(2);  
  end     
   
alphay = alphay_0./sqrt(eps); 
alphaz = sqrt(1-alphay.^2);

n_right_down = sqrt(eps + eps_mag*( u(2)*alphay - u(3)*alphaz));
n_left_down  = sqrt(eps - eps_mag*( u(2)*alphay - u(3)*alphaz));
n_right_up   = sqrt(eps + eps_mag*( u(2)*alphay + u(3)*alphaz));
n_left_up    = sqrt(eps - eps_mag*( u(2)*alphay + u(3)*alphaz));

alphay_right_down  = alphay_0./n_right_down;
alphaz_right_down  = sqrt(1-alphay_right_down.^2);
alphay_left_down   = alphay_0./n_left_down;
alphaz_left_down   = sqrt(1-alphay_left_down.^2) ;
alphay_right_up    = alphay_0./n_right_up;
alphaz_right_up    = sqrt(1-alphay_right_up.^2);
alphay_left_up     = alphay_0./n_left_up;
alphaz_left_up     = sqrt(1-alphay_left_up.^2);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
a = -1 -1i*eps_xy*alphaz_right_down  -1i*eps_xz*alphay_right_down;
e = - eps_xy + 1i*alphaz_right_down -1i*eps_yz*alphay_right_down;
i = -1i*n_right_down.*a;
m = -alphaz_right_down.*n_right_down.*a;

b = 1 -1i*eps_xy*alphaz_left_down -1i*eps_xz*alphay_left_down;
f = eps_xy + 1i*alphaz_left_down  -1i.*eps_yz*alphay_left_down;
j = 1i*n_left_down.*b;
n = -alphaz_left_down.*n_left_down.*b;

c = -1 -1i*eps_xy*alphaz_right_up -1i.*eps_xz*alphay_right_up;
g = -eps_xy - 1i.*alphaz_right_up -1i*eps_yz*alphay_right_up;
q = -1i.*n_right_up.*c;
o = alphaz_right_up.*n_right_up.*c;

d = 1 -1i*eps_xy*alphaz_left_up -1i*eps_xz*alphay_left_up;
h = eps_xy - 1i*alphaz_left_up -1i.*eps_yz*alphay_left_up;
l = 1i.*n_left_up.*d;
p = alphaz_left_up.*n_left_up.*d;

Am(1,1,k,:) = a;
Am(2,1,k,:) = e;
Am(3,1,k,:) = i;     
Am(4,1,k,:) = m;
        
Am(1,2,k,:) =  b;
Am(2,2,k,:) =  f;
Am(3,2,k,:) =  j;
Am(4,2,k,:) =  n;
        
Am(1,3,k,:) =  c;
Am(2,3,k,:) =  g;
Am(3,3,k,:) =  q;
Am(4,3,k,:) =  o;
        
Am(1,4,k,:) =  d;
Am(2,4,k,:) =  h;
Am(3,4,k,:) =  l;
Am(4,4,k,:) =  p;

det=(a.*(f.*q.*p+j.*o.*h+g.*l.*n-n.*q.*h-o.*l.*f-g.*j.*p)-...
    b.*(e.*q.*p+i.*o.*h+g.*l.*m-m.*q.*h-o.*l.*e-i.*g.*p)+...
    c.*(e.*j.*p+i.*n.*h+f.*l.*m-m.*j.*h-n.*l.*e-i.*f.*p)-...
    d.*(e.*j.*o+i.*n.*g+f.*q.*m-m.*j.*g-n.*q.*e-i.*f.*o))/twoeps2;

Am_m1(1,1,k,:)=   (f.*q.*p+j.*o.*h+g.*l.*n-n.*q.*h-o.*l.*f-j.*g.*p)./det;
Am_m1(1,2,k,:)=  -(b.*q.*p+j.*o.*d+c.*l.*n-n.*q.*d-o.*l.*b-j.*c.*p)./det;
Am_m1(1,3,k,:)=   (b.*g.*p+f.*o.*d+c.*h.*n-n.*g.*d-o.*h.*b-f.*c.*p)./det;
Am_m1(1,4,k,:)=  -(b.*g.*l+f.*q.*d+c.*h.*j-j.*g.*d-q.*h.*b-f.*c.*l)./det;

Am_m1(2,1,k,:)=  -(e.*q.*p+i.*o.*h+g.*l.*m-m.*q.*h-o.*l.*e-i.*g.*p)./det;
Am_m1(2,2,k,:)=   (a.*q.*p+i.*o.*d+c.*l.*m-m.*q.*d-o.*l.*a-i.*c.*p)./det;
Am_m1(2,3,k,:)=  -(a.*g.*p+e.*o.*d+c.*h.*m-m.*g.*d-o.*h.*a-e.*c.*p)./det;
Am_m1(2,4,k,:)=   (a.*g.*l+e.*q.*d+c.*h.*i-i.*g.*d-q.*h.*a-e.*c.*l)./det;

Am_m1(3,1,k,:)=   (e.*j.*p+i.*n.*h+f.*l.*m-m.*j.*h-n.*l.*e-i.*f.*p)./det;
Am_m1(3,2,k,:)=  -(a.*j.*p+i.*n.*d+b.*l.*m-m.*j.*d-n.*l.*a-i.*b.*p)./det;
Am_m1(3,3,k,:)=   (a.*f.*p+e.*n.*d+b.*h.*m-m.*f.*d-n.*h.*a-e.*b.*p)./det;
Am_m1(3,4,k,:)=  -(a.*f.*l+e.*j.*d+b.*h.*i-i.*f.*d-j.*h.*a-e.*b.*l)./det;

Am_m1(4,1,k,:)=  -(e.*j.*o+i.*n.*g+f.*q.*m-m.*j.*g-n.*q.*e-i.*f.*o)./det;
Am_m1(4,2,k,:)=   (a.*j.*o+i.*n.*c+b.*q.*m-m.*j.*c-n.*q.*a-i.*b.*o)./det;
Am_m1(4,3,k,:)=  -(a.*f.*o+e.*n.*c+b.*g.*m-m.*f.*c-n.*g.*a-e.*b.*o)./det;
Am_m1(4,4,k,:)=   (a.*f.*q+e.*j.*c+b.*g.*i-i.*f.*c-j.*g.*a-e.*b.*q)./det;

%%

a = -b;
e = eps_xy +1i*alphaz_left_down +1i*eps_yz*alphay_left_down; 
i =  j;
m = -n;

b = 1 +1i*eps_xy*alphaz_right_down +1i*eps_xz*alphay_right_down;
f = -eps_xy +1i*alphaz_right_down +1i*eps_yz*alphay_right_down;
j = 1i*n_right_down.*b;
n = -alphaz_right_down.*n_right_down.*b;

c = -d;
g = -eps_xy -1i*alphaz_left_up -1i*eps_yz*alphay_left_up;
q = l;
o = -p;

d = 1 +1i*eps_xy*alphaz_right_up +1i*eps_xz*alphay_right_up;
h = -eps_xy -1i*alphaz_right_up +1i*eps_yz*alphay_right_up;
l = 1i*n_right_up.*d;
p = alphaz_right_up.*n_right_up.*d;

Am_phi(1,1,k,:) = a;
Am_phi(2,1,k,:) = e;
Am_phi(3,1,k,:) = i;
Am_phi(4,1,k,:) = m;
        
Am_phi(1,2,k,:) =  b;
Am_phi(2,2,k,:) =  f;
Am_phi(3,2,k,:) =  j;
Am_phi(4,2,k,:) =  n;
        
Am_phi(1,3,k,:) =  c;
Am_phi(2,3,k,:) =  g;
Am_phi(3,3,k,:) =  q;
Am_phi(4,3,k,:) =  o;
        
Am_phi(1,4,k,:) =  d;
Am_phi(2,4,k,:) =  h;
Am_phi(3,4,k,:) =  l;
Am_phi(4,4,k,:) =  p;

detAm_phi=(a.*(f.*q.*p+j.*o.*h+g.*l.*n-n.*q.*h-o.*l.*f-g.*j.*p)-...
    b.*(e.*q.*p+i.*o.*h+g.*l.*m-m.*q.*h-o.*l.*e-i.*g.*p)+...
    c.*(e.*j.*p+i.*n.*h+f.*l.*m-m.*j.*h-n.*l.*e-i.*f.*p)-...
    d.*(e.*j.*o+i.*n.*g+f.*q.*m-m.*j.*g-n.*q.*e-i.*f.*o))/twoeps2;

Am_m1_phi(1,1,k,:)=   (f.*q.*p+j.*o.*h+g.*l.*n-n.*q.*h-o.*l.*f-j.*g.*p)./detAm_phi;
Am_m1_phi(1,2,k,:)=  -(b.*q.*p+j.*o.*d+c.*l.*n-n.*q.*d-o.*l.*b-j.*c.*p)./detAm_phi;
Am_m1_phi(1,3,k,:)=   (b.*g.*p+f.*o.*d+c.*h.*n-n.*g.*d-o.*h.*b-f.*c.*p)./detAm_phi;
Am_m1_phi(1,4,k,:)=  -(b.*g.*l+f.*q.*d+c.*h.*j-j.*g.*d-q.*h.*b-f.*c.*l)./detAm_phi;

Am_m1_phi(2,1,k,:)=  -(e.*q.*p+i.*o.*h+g.*l.*m-m.*q.*h-o.*l.*e-i.*g.*p)./detAm_phi;
Am_m1_phi(2,2,k,:)=   (a.*q.*p+i.*o.*d+c.*l.*m-m.*q.*d-o.*l.*a-i.*c.*p)./detAm_phi;
Am_m1_phi(2,3,k,:)=  -(a.*g.*p+e.*o.*d+c.*h.*m-m.*g.*d-o.*h.*a-e.*c.*p)./detAm_phi;
Am_m1_phi(2,4,k,:)=   (a.*g.*l+e.*q.*d+c.*h.*i-i.*g.*d-q.*h.*a-e.*c.*l)./detAm_phi;

Am_m1_phi(3,1,k,:)=   (e.*j.*p+i.*n.*h+f.*l.*m-m.*j.*h-n.*l.*e-i.*f.*p)./detAm_phi;
Am_m1_phi(3,2,k,:)=  -(a.*j.*p+i.*n.*d+b.*l.*m-m.*j.*d-n.*l.*a-i.*b.*p)./detAm_phi;
Am_m1_phi(3,3,k,:)=   (a.*f.*p+e.*n.*d+b.*h.*m-m.*f.*d-n.*h.*a-e.*b.*p)./detAm_phi;
Am_m1_phi(3,4,k,:)=  -(a.*f.*l+e.*j.*d+b.*h.*i-i.*f.*d-j.*h.*a-e.*b.*l)./detAm_phi;

Am_m1_phi(4,1,k,:)=  -(e.*j.*o+i.*n.*g+f.*q.*m-m.*j.*g-n.*q.*e-i.*f.*o)./detAm_phi;
Am_m1_phi(4,2,k,:)=   (a.*j.*o+i.*n.*c+b.*q.*m-m.*j.*c-n.*q.*a-i.*b.*o)./detAm_phi;
Am_m1_phi(4,3,k,:)=  -(a.*f.*o+e.*n.*c+b.*g.*m-m.*f.*c-n.*g.*a-e.*b.*o)./detAm_phi;
Am_m1_phi(4,4,k,:)=   (a.*f.*q+e.*j.*c+b.*g.*i-i.*f.*c-j.*g.*a-e.*b.*q)./detAm_phi;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

kz(k,:) = wave_k .* sqrt(eps) .* alphaz;
phase=wave_k.*thick(k);
        
 P(1,1,k,:) = exp(1i*phase.*n_right_down.*alphaz_right_down);
 P(2,2,k,:) = exp(1i*phase.*n_left_down.*alphaz_left_down);
 P(3,3,k,:) = exp(-1i*phase.*n_right_up.*alphaz_right_up);
 P(4,4,k,:) = exp(-1i*phase.*n_left_up.*alphaz_left_up);
 
 P_phi(2,2,k,:)=P(1,1,k,:);
 P_phi(1,1,k,:)=P(2,2,k,:);
 P_phi(3,3,k,:)=P(4,4,k,:);
 P_phi(4,4,k,:)=P(3,3,k,:);

 
end

for kk=2:1:length(sequence) 
j=sequence(kk-1);
k=sequence(kk);

R(1,1,1,:) = exp(-((-kz(k,:)+kz(j,:)).^2).*rough(k)^2 /2);
R(1,1,2,:) = exp(-(( kz(k,:)+kz(j,:)).^2).*rough(k)^2 /2);

F(1,1,kk,:)= ...
    (Am_m1(1,1,k,:).*Am(1,1,j,:) + Am_m1(1,2,k,:).*Am(2,1,j,:)...
    +Am_m1(1,3,k,:).*Am(3,1,j,:) + Am_m1(1,4,k,:).*Am(4,1,j,:)).*R(1,1,1,:);
F(1,2,kk,:)= ...
    (Am_m1(1,1,k,:).*Am(1,2,j,:) + Am_m1(1,2,k,:).*Am(2,2,j,:)...
    +Am_m1(1,3,k,:).*Am(3,2,j,:) + Am_m1(1,4,k,:).*Am(4,2,j,:)).*R(1,1,1,:);
F(1,3,kk,:)= ...
    (Am_m1(1,1,k,:).*Am(1,3,j,:) + Am_m1(1,2,k,:).*Am(2,3,j,:)...
    +Am_m1(1,3,k,:).*Am(3,3,j,:) + Am_m1(1,4,k,:).*Am(4,3,j,:)).*R(1,1,2,:);
F(1,4,kk,:)= ...
    (Am_m1(1,1,k,:).*Am(1,4,j,:) + Am_m1(1,2,k,:).*Am(2,4,j,:)...
    +Am_m1(1,3,k,:).*Am(3,4,j,:) + Am_m1(1,4,k,:).*Am(4,4,j,:)).*R(1,1,2,:);

F(2,1,kk,:)= ...
    (Am_m1(2,1,k,:).*Am(1,1,j,:) + Am_m1(2,2,k,:).*Am(2,1,j,:)...
    +Am_m1(2,3,k,:).*Am(3,1,j,:) + Am_m1(2,4,k,:).*Am(4,1,j,:)).*R(1,1,1,:);
F(2,2,kk,:)= ...
    (Am_m1(2,1,k,:).*Am(1,2,j,:) + Am_m1(2,2,k,:).*Am(2,2,j,:)...
    +Am_m1(2,3,k,:).*Am(3,2,j,:) + Am_m1(2,4,k,:).*Am(4,2,j,:)).*R(1,1,1,:);
F(2,3,kk,:)= ...
    (Am_m1(2,1,k,:).*Am(1,3,j,:) + Am_m1(2,2,k,:).*Am(2,3,j,:)...
    +Am_m1(2,3,k,:).*Am(3,3,j,:) + Am_m1(2,4,k,:).*Am(4,3,j,:)).*R(1,1,2,:);
F(2,4,kk,:)= ...
    (Am_m1(2,1,k,:).*Am(1,4,j,:) + Am_m1(2,2,k,:).*Am(2,4,j,:)...
    +Am_m1(2,3,k,:).*Am(3,4,j,:) + Am_m1(2,4,k,:).*Am(4,4,j,:)).*R(1,1,2,:);

F(3,1,kk,:)= ...
    (Am_m1(3,1,k,:).*Am(1,1,j,:) + Am_m1(3,2,k,:).*Am(2,1,j,:)...
    +Am_m1(3,3,k,:).*Am(3,1,j,:) + Am_m1(3,4,k,:).*Am(4,1,j,:)).*R(1,1,2,:);
F(3,2,kk,:)= ...
    (Am_m1(3,1,k,:).*Am(1,2,j,:) + Am_m1(3,2,k,:).*Am(2,2,j,:)...
    +Am_m1(3,3,k,:).*Am(3,2,j,:) + Am_m1(3,4,k,:).*Am(4,2,j,:)).*R(1,1,2,:);
F(3,3,kk,:)= ...
    (Am_m1(3,1,k,:).*Am(1,3,j,:) + Am_m1(3,2,k,:).*Am(2,3,j,:)...
    +Am_m1(3,3,k,:).*Am(3,3,j,:) + Am_m1(3,4,k,:).*Am(4,3,j,:)).*R(1,1,1,:);
F(3,4,kk,:)= ...
    (Am_m1(3,1,k,:).*Am(1,4,j,:) + Am_m1(3,2,k,:).*Am(2,4,j,:)...
    +Am_m1(3,3,k,:).*Am(3,4,j,:) + Am_m1(3,4,k,:).*Am(4,4,j,:)).*R(1,1,1,:);

F(4,1,kk,:)= ...
    (Am_m1(4,1,k,:).*Am(1,1,j,:) + Am_m1(4,2,k,:).*Am(2,1,j,:)...
    +Am_m1(4,3,k,:).*Am(3,1,j,:) + Am_m1(4,4,k,:).*Am(4,1,j,:)).*R(1,1,2,:);
F(4,2,kk,:)= ...
    (Am_m1(4,1,k,:).*Am(1,2,j,:) + Am_m1(4,2,k,:).*Am(2,2,j,:)...
    +Am_m1(4,3,k,:).*Am(3,2,j,:) + Am_m1(4,4,k,:).*Am(4,2,j,:)).*R(1,1,2,:);
F(4,3,kk,:)= ...
    (Am_m1(4,1,k,:).*Am(1,3,j,:) + Am_m1(4,2,k,:).*Am(2,3,j,:)...
    +Am_m1(4,3,k,:).*Am(3,3,j,:) + Am_m1(4,4,k,:).*Am(4,3,j,:)).*R(1,1,1,:);
F(4,4,kk,:)= ...
    (Am_m1(4,1,k,:).*Am(1,4,j,:) + Am_m1(4,2,k,:).*Am(2,4,j,:)...
    +Am_m1(4,3,k,:).*Am(3,4,j,:) + Am_m1(4,4,k,:).*Am(4,4,j,:)).*R(1,1,1,:);
%%%%%%%%%%%%%%%%%%%%%
F_phi(1,1,kk,:)= ...
    (Am_m1_phi(1,1,k,:).*Am_phi(1,1,j,:) + Am_m1_phi(1,2,k,:).*Am_phi(2,1,j,:)...
    +Am_m1_phi(1,3,k,:).*Am_phi(3,1,j,:) + Am_m1_phi(1,4,k,:).*Am_phi(4,1,j,:)).*R(1,1,1,:);
F_phi(1,2,kk,:)= ...
    (Am_m1_phi(1,1,k,:).*Am_phi(1,2,j,:) + Am_m1_phi(1,2,k,:).*Am_phi(2,2,j,:)...
    +Am_m1_phi(1,3,k,:).*Am_phi(3,2,j,:) + Am_m1_phi(1,4,k,:).*Am_phi(4,2,j,:)).*R(1,1,1,:);
F_phi(1,3,kk,:)= ...
    (Am_m1_phi(1,1,k,:).*Am_phi(1,3,j,:) + Am_m1_phi(1,2,k,:).*Am_phi(2,3,j,:)...
    +Am_m1_phi(1,3,k,:).*Am_phi(3,3,j,:) + Am_m1_phi(1,4,k,:).*Am_phi(4,3,j,:)).*R(1,1,2,:);
F_phi(1,4,kk,:)= ...
    (Am_m1_phi(1,1,k,:).*Am_phi(1,4,j,:) + Am_m1_phi(1,2,k,:).*Am_phi(2,4,j,:)...
    +Am_m1_phi(1,3,k,:).*Am_phi(3,4,j,:) + Am_m1_phi(1,4,k,:).*Am_phi(4,4,j,:)).*R(1,1,2,:);

F_phi(2,1,kk,:)= ...
    (Am_m1_phi(2,1,k,:).*Am_phi(1,1,j,:) + Am_m1_phi(2,2,k,:).*Am_phi(2,1,j,:)...
    +Am_m1_phi(2,3,k,:).*Am_phi(3,1,j,:) + Am_m1_phi(2,4,k,:).*Am_phi(4,1,j,:)).*R(1,1,1,:);
F_phi(2,2,kk,:)= ...
    (Am_m1_phi(2,1,k,:).*Am_phi(1,2,j,:) + Am_m1_phi(2,2,k,:).*Am_phi(2,2,j,:)...
    +Am_m1_phi(2,3,k,:).*Am_phi(3,2,j,:) + Am_m1_phi(2,4,k,:).*Am_phi(4,2,j,:)).*R(1,1,1,:);
F_phi(2,3,kk,:)= ...
    (Am_m1_phi(2,1,k,:).*Am_phi(1,3,j,:) + Am_m1_phi(2,2,k,:).*Am_phi(2,3,j,:)...
    +Am_m1_phi(2,3,k,:).*Am_phi(3,3,j,:) + Am_m1_phi(2,4,k,:).*Am_phi(4,3,j,:)).*R(1,1,2,:);
F_phi(2,4,kk,:)= ...
    (Am_m1_phi(2,1,k,:).*Am_phi(1,4,j,:) + Am_m1_phi(2,2,k,:).*Am_phi(2,4,j,:)...
    +Am_m1_phi(2,3,k,:).*Am_phi(3,4,j,:) + Am_m1_phi(2,4,k,:).*Am_phi(4,4,j,:)).*R(1,1,2,:);

F_phi(3,1,kk,:)= ...
    (Am_m1_phi(3,1,k,:).*Am_phi(1,1,j,:) + Am_m1_phi(3,2,k,:).*Am_phi(2,1,j,:)...
    +Am_m1_phi(3,3,k,:).*Am_phi(3,1,j,:) + Am_m1_phi(3,4,k,:).*Am_phi(4,1,j,:)).*R(1,1,2,:);
F_phi(3,2,kk,:)= ...
    (Am_m1_phi(3,1,k,:).*Am_phi(1,2,j,:) + Am_m1_phi(3,2,k,:).*Am_phi(2,2,j,:)...
    +Am_m1_phi(3,3,k,:).*Am_phi(3,2,j,:) + Am_m1_phi(3,4,k,:).*Am_phi(4,2,j,:)).*R(1,1,2,:);
F_phi(3,3,kk,:)= ...
    (Am_m1_phi(3,1,k,:).*Am_phi(1,3,j,:) + Am_m1_phi(3,2,k,:).*Am_phi(2,3,j,:)...
    +Am_m1_phi(3,3,k,:).*Am_phi(3,3,j,:) + Am_m1_phi(3,4,k,:).*Am_phi(4,3,j,:)).*R(1,1,1,:);
F_phi(3,4,kk,:)= ...
    (Am_m1_phi(3,1,k,:).*Am_phi(1,4,j,:) + Am_m1_phi(3,2,k,:).*Am_phi(2,4,j,:)...
    +Am_m1_phi(3,3,k,:).*Am_phi(3,4,j,:) + Am_m1_phi(3,4,k,:).*Am_phi(4,4,j,:)).*R(1,1,1,:);

F_phi(4,1,kk,:)= ...
    (Am_m1_phi(4,1,k,:).*Am_phi(1,1,j,:) + Am_m1_phi(4,2,k,:).*Am_phi(2,1,j,:)...
    +Am_m1_phi(4,3,k,:).*Am_phi(3,1,j,:) + Am_m1_phi(4,4,k,:).*Am_phi(4,1,j,:)).*R(1,1,2,:);
F_phi(4,2,kk,:)= ...
    (Am_m1_phi(4,1,k,:).*Am_phi(1,2,j,:) + Am_m1_phi(4,2,k,:).*Am_phi(2,2,j,:)...
    +Am_m1_phi(4,3,k,:).*Am_phi(3,2,j,:) + Am_m1_phi(4,4,k,:).*Am_phi(4,2,j,:)).*R(1,1,2,:);
F_phi(4,3,kk,:)= ...
    (Am_m1_phi(4,1,k,:).*Am_phi(1,3,j,:) + Am_m1_phi(4,2,k,:).*Am_phi(2,3,j,:)...
    +Am_m1_phi(4,3,k,:).*Am_phi(3,3,j,:) + Am_m1_phi(4,4,k,:).*Am_phi(4,3,j,:)).*R(1,1,1,:);
F_phi(4,4,kk,:)= ...
    (Am_m1_phi(4,1,k,:).*Am_phi(1,4,j,:) + Am_m1_phi(4,2,k,:).*Am_phi(2,4,j,:)...
    +Am_m1_phi(4,3,k,:).*Am_phi(3,4,j,:) + Am_m1_phi(4,4,k,:).*Am_phi(4,4,j,:)).*R(1,1,1,:);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

S(1,1,kk,:)= ...
    (F(1,1,kk,:).*S(1,1,kk-1,:) + F(1,2,kk,:).*S(2,1,kk-1,:)...
    +F(1,3,kk,:).*S(3,1,kk-1,:) + F(1,4,kk,:).*S(4,1,kk-1,:)).*P(1,1,k,:);
S(1,2,kk,:)= ...
    (F(1,1,kk,:).*S(1,2,kk-1,:) + F(1,2,kk,:).*S(2,2,kk-1,:)...
    +F(1,3,kk,:).*S(3,2,kk-1,:) + F(1,4,kk,:).*S(4,2,kk-1,:)).*P(1,1,k,:);
S(1,3,kk,:)= ...
    (F(1,1,kk,:).*S(1,3,kk-1,:) + F(1,2,kk,:).*S(2,3,kk-1,:)...
    +F(1,3,kk,:).*S(3,3,kk-1,:) + F(1,4,kk,:).*S(4,3,kk-1,:)).*P(1,1,k,:);
S(1,4,kk,:)= ...
    (F(1,1,kk,:).*S(1,4,kk-1,:) + F(1,2,kk,:).*S(2,4,kk-1,:)...
    +F(1,3,kk,:).*S(3,4,kk-1,:) + F(1,4,kk,:).*S(4,4,kk-1,:)).*P(1,1,k,:);

S(2,1,kk,:)= ...
    (F(2,1,kk,:).*S(1,1,kk-1,:) + F(2,2,kk,:).*S(2,1,kk-1,:)...
    +F(2,3,kk,:).*S(3,1,kk-1,:) + F(2,4,kk,:).*S(4,1,kk-1,:)).*P(2,2,k,:);
S(2,2,kk,:)= ...
    (F(2,1,kk,:).*S(1,2,kk-1,:) + F(2,2,kk,:).*S(2,2,kk-1,:)...
    +F(2,3,kk,:).*S(3,2,kk-1,:) + F(2,4,kk,:).*S(4,2,kk-1,:)).*P(2,2,k,:);
S(2,3,kk,:)= ...
    (F(2,1,kk,:).*S(1,3,kk-1,:) + F(2,2,kk,:).*S(2,3,kk-1,:)...
    +F(2,3,kk,:).*S(3,3,kk-1,:) + F(2,4,kk,:).*S(4,3,kk-1,:)).*P(2,2,k,:);
S(2,4,kk,:)= ...
    (F(2,1,kk,:).*S(1,4,kk-1,:) + F(2,2,kk,:).*S(2,4,kk-1,:)...
    +F(2,3,kk,:).*S(3,4,kk-1,:) + F(2,4,kk,:).*S(4,4,kk-1,:)).*P(2,2,k,:);

S(3,1,kk,:)= ...
    (F(3,1,kk,:).*S(1,1,kk-1,:) + F(3,2,kk,:).*S(2,1,kk-1,:)...
    +F(3,3,kk,:).*S(3,1,kk-1,:) + F(3,4,kk,:).*S(4,1,kk-1,:)).*P(3,3,k,:);
S(3,2,kk,:)= ...
    (F(3,1,kk,:).*S(1,2,kk-1,:) + F(3,2,kk,:).*S(2,2,kk-1,:)...
    +F(3,3,kk,:).*S(3,2,kk-1,:) + F(3,4,kk,:).*S(4,2,kk-1,:)).*P(3,3,k,:);
S(3,3,kk,:)= ...
    (F(3,1,kk,:).*S(1,3,kk-1,:) + F(3,2,kk,:).*S(2,3,kk-1,:)...
    +F(3,3,kk,:).*S(3,3,kk-1,:) + F(3,4,kk,:).*S(4,3,kk-1,:)).*P(3,3,k,:);
S(3,4,kk,:)= ...
    (F(3,1,kk,:).*S(1,4,kk-1,:) + F(3,2,kk,:).*S(2,4,kk-1,:)...
    +F(3,3,kk,:).*S(3,4,kk-1,:) + F(3,4,kk,:).*S(4,4,kk-1,:)).*P(3,3,k,:);

S(4,1,kk,:)= ...
    (F(4,1,kk,:).*S(1,1,kk-1,:) + F(4,2,kk,:).*S(2,1,kk-1,:)...
    +F(4,3,kk,:).*S(3,1,kk-1,:) + F(4,4,kk,:).*S(4,1,kk-1,:)).*P(4,4,k,:);
S(4,2,kk,:)= ...
    (F(4,1,kk,:).*S(1,2,kk-1,:) + F(4,2,kk,:).*S(2,2,kk-1,:)...
    +F(4,3,kk,:).*S(3,2,kk-1,:) + F(4,4,kk,:).*S(4,2,kk-1,:)).*P(4,4,k,:);
S(4,3,kk,:)= ...
    (F(4,1,kk,:).*S(1,3,kk-1,:) + F(4,2,kk,:).*S(2,3,kk-1,:)...
    +F(4,3,kk,:).*S(3,3,kk-1,:) + F(4,4,kk,:).*S(4,3,kk-1,:)).*P(4,4,k,:);
S(4,4,kk,:)= ...
    (F(4,1,kk,:).*S(1,4,kk-1,:) + F(4,2,kk,:).*S(2,4,kk-1,:)...
    +F(4,3,kk,:).*S(3,4,kk-1,:) + F(4,4,kk,:).*S(4,4,kk-1,:)).*P(4,4,k,:);
%%%%%%%%%
S_phi(1,1,kk,:)= ...
    (F_phi(1,1,kk,:).*S_phi(1,1,kk-1,:) + F_phi(1,2,kk,:).*S_phi(2,1,kk-1,:)...
    +F_phi(1,3,kk,:).*S_phi(3,1,kk-1,:) + F_phi(1,4,kk,:).*S_phi(4,1,kk-1,:)).*P_phi(1,1,k,:);
S_phi(1,2,kk,:)= ...
    (F_phi(1,1,kk,:).*S_phi(1,2,kk-1,:) + F_phi(1,2,kk,:).*S_phi(2,2,kk-1,:)...
    +F_phi(1,3,kk,:).*S_phi(3,2,kk-1,:) + F_phi(1,4,kk,:).*S_phi(4,2,kk-1,:)).*P_phi(1,1,k,:);
S_phi(1,3,kk,:)= ...
    (F_phi(1,1,kk,:).*S_phi(1,3,kk-1,:) + F_phi(1,2,kk,:).*S_phi(2,3,kk-1,:)...
    +F_phi(1,3,kk,:).*S_phi(3,3,kk-1,:) + F_phi(1,4,kk,:).*S_phi(4,3,kk-1,:)).*P_phi(1,1,k,:);
S_phi(1,4,kk,:)= ...
    (F_phi(1,1,kk,:).*S_phi(1,4,kk-1,:) + F_phi(1,2,kk,:).*S_phi(2,4,kk-1,:)...
    +F_phi(1,3,kk,:).*S_phi(3,4,kk-1,:) + F_phi(1,4,kk,:).*S_phi(4,4,kk-1,:)).*P_phi(1,1,k,:);

S_phi(2,1,kk,:)= ...
    (F_phi(2,1,kk,:).*S_phi(1,1,kk-1,:) + F_phi(2,2,kk,:).*S_phi(2,1,kk-1,:)...
    +F_phi(2,3,kk,:).*S_phi(3,1,kk-1,:) + F_phi(2,4,kk,:).*S_phi(4,1,kk-1,:)).*P_phi(2,2,k,:);
S_phi(2,2,kk,:)= ...
    (F_phi(2,1,kk,:).*S_phi(1,2,kk-1,:) + F_phi(2,2,kk,:).*S_phi(2,2,kk-1,:)...
    +F_phi(2,3,kk,:).*S_phi(3,2,kk-1,:) + F_phi(2,4,kk,:).*S_phi(4,2,kk-1,:)).*P_phi(2,2,k,:);
S_phi(2,3,kk,:)= ...
    (F_phi(2,1,kk,:).*S_phi(1,3,kk-1,:) + F_phi(2,2,kk,:).*S_phi(2,3,kk-1,:)...
    +F_phi(2,3,kk,:).*S_phi(3,3,kk-1,:) + F_phi(2,4,kk,:).*S_phi(4,3,kk-1,:)).*P_phi(2,2,k,:);
S_phi(2,4,kk,:)= ...
    (F_phi(2,1,kk,:).*S_phi(1,4,kk-1,:) + F_phi(2,2,kk,:).*S_phi(2,4,kk-1,:)...
    +F_phi(2,3,kk,:).*S_phi(3,4,kk-1,:) + F_phi(2,4,kk,:).*S_phi(4,4,kk-1,:)).*P_phi(2,2,k,:);

S_phi(3,1,kk,:)= ...
    (F_phi(3,1,kk,:).*S_phi(1,1,kk-1,:) + F_phi(3,2,kk,:).*S_phi(2,1,kk-1,:)...
    +F_phi(3,3,kk,:).*S_phi(3,1,kk-1,:) + F_phi(3,4,kk,:).*S_phi(4,1,kk-1,:)).*P_phi(3,3,k,:);
S_phi(3,2,kk,:)= ...
    (F_phi(3,1,kk,:).*S_phi(1,2,kk-1,:) + F_phi(3,2,kk,:).*S_phi(2,2,kk-1,:)...
    +F_phi(3,3,kk,:).*S_phi(3,2,kk-1,:) + F_phi(3,4,kk,:).*S_phi(4,2,kk-1,:)).*P_phi(3,3,k,:);
S_phi(3,3,kk,:)= ...
    (F_phi(3,1,kk,:).*S_phi(1,3,kk-1,:) + F_phi(3,2,kk,:).*S_phi(2,3,kk-1,:)...
    +F_phi(3,3,kk,:).*S_phi(3,3,kk-1,:) + F_phi(3,4,kk,:).*S_phi(4,3,kk-1,:)).*P_phi(3,3,k,:);
S_phi(3,4,kk,:)= ...
    (F_phi(3,1,kk,:).*S_phi(1,4,kk-1,:) + F_phi(3,2,kk,:).*S_phi(2,4,kk-1,:)...
    +F_phi(3,3,kk,:).*S_phi(3,4,kk-1,:) + F_phi(3,4,kk,:).*S_phi(4,4,kk-1,:)).*P_phi(3,3,k,:);

S_phi(4,1,kk,:)= ...
    (F_phi(4,1,kk,:).*S_phi(1,1,kk-1,:) + F_phi(4,2,kk,:).*S_phi(2,1,kk-1,:)...
    +F_phi(4,3,kk,:).*S_phi(3,1,kk-1,:) + F_phi(4,4,kk,:).*S_phi(4,1,kk-1,:)).*P_phi(4,4,k,:);
S_phi(4,2,kk,:)= ...
    (F_phi(4,1,kk,:).*S_phi(1,2,kk-1,:) + F_phi(4,2,kk,:).*S_phi(2,2,kk-1,:)...
    +F_phi(4,3,kk,:).*S_phi(3,2,kk-1,:) + F_phi(4,4,kk,:).*S_phi(4,2,kk-1,:)).*P_phi(4,4,k,:);
S_phi(4,3,kk,:)= ...
    (F_phi(4,1,kk,:).*S_phi(1,3,kk-1,:) + F_phi(4,2,kk,:).*S_phi(2,3,kk-1,:)...
    +F_phi(4,3,kk,:).*S_phi(3,3,kk-1,:) + F_phi(4,4,kk,:).*S_phi(4,3,kk-1,:)).*P_phi(4,4,k,:);
S_phi(4,4,kk,:)= ...
    (F_phi(4,1,kk,:).*S_phi(1,4,kk-1,:) + F_phi(4,2,kk,:).*S_phi(2,4,kk-1,:)...
    +F_phi(4,3,kk,:).*S_phi(3,4,kk-1,:) + F_phi(4,4,kk,:).*S_phi(4,4,kk-1,:)).*P_phi(4,4,k,:);

end

det=S(3,3,kk,:).*S(4,4,kk,:)-S(4,3,kk,:).*S(3,4,kk,:);
det_phi=S_phi(3,3,kk,:).*S_phi(4,4,kk,:)-S_phi(4,3,kk,:).*S_phi(3,4,kk,:);

M_final_temp(1,1,:)=det.\(S(4,1,kk,:).*S(3,4,kk,:)-S(3,1,kk,:).*S(4,4,kk,:));
M_final_temp(1,2,:)=det.\(S(4,2,kk,:).*S(3,4,kk,:)-S(3,2,kk,:).*S(4,4,kk,:));
M_final_temp(2,1,:)=det.\(S(3,1,kk,:).*S(4,3,kk,:)-S(4,1,kk,:).*S(3,3,kk,:));
M_final_temp(2,2,:)=det.\(S(3,2,kk,:).*S(4,3,kk,:)-S(4,2,kk,:).*S(3,3,kk,:));

M_final_temp_phi(1,1,:)=det_phi.\(S_phi(4,1,kk,:).*S_phi(3,4,kk,:)...
    -S_phi(3,1,kk,:).*S_phi(4,4,kk,:));
M_final_temp_phi(1,2,:)=det_phi.\(S_phi(4,2,kk,:).*S_phi(3,4,kk,:)...
    -S_phi(3,2,kk,:).*S_phi(4,4,kk,:));
M_final_temp_phi(2,1,:)=det_phi.\(S_phi(3,1,kk,:).*S_phi(4,3,kk,:)...
    -S_phi(4,1,kk,:).*S_phi(3,3,kk,:));
M_final_temp_phi(2,2,:)=det_phi.\(S_phi(3,2,kk,:).*S_phi(4,3,kk,:)...
    -S_phi(4,2,kk,:).*S_phi(3,3,kk,:));

lcalc.M_final(1,1,:)=0.5*(M_final_temp(1,1,:)-M_final_temp(1,2,:)...
-M_final_temp(2,1,:)+M_final_temp(2,2,:));

lcalc.M_final(1,2,:)=0.5*(-1i*M_final_temp(1,1,:)-1i*M_final_temp(1,2,:)...
    +1i*M_final_temp(2,1,:)+1i*M_final_temp(2,2,:));

lcalc.M_final(2,1,:)=0.5*(1i*M_final_temp(1,1,:)-1i*M_final_temp(1,2,:)...
    +1i*M_final_temp(2,1,:)-1i*M_final_temp(2,2,:));

lcalc.M_final(2,2,:)=0.5*(M_final_temp(2,1,:)+M_final_temp(2,2,:)...
    +M_final_temp(1,1,:)+M_final_temp(1,2,:));

lcalc.M_final_phi(1,1,:)=0.5*(M_final_temp_phi(1,1,:)-M_final_temp_phi(1,2,:)...
-M_final_temp_phi(2,1,:)+M_final_temp_phi(2,2,:));

lcalc.M_final_phi(1,2,:)=0.5*(-1i*M_final_temp_phi(1,1,:)-1i*M_final_temp_phi(1,2,:)...
    +1i*M_final_temp_phi(2,1,:)+1i*M_final_temp_phi(2,2,:));

lcalc.M_final_phi(2,1,:)=0.5*(1i*M_final_temp_phi(1,1,:)-1i*M_final_temp_phi(1,2,:)...
    +1i*M_final_temp_phi(2,1,:)-1i*M_final_temp_phi(2,2,:));

lcalc.M_final_phi(2,2,:)=0.5*(M_final_temp_phi(2,1,:)+M_final_temp_phi(2,2,:)...
    +M_final_temp_phi(1,1,:)+M_final_temp_phi(1,2,:));


end